/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeBoolean;
import org.mozilla.javascript.NativeNumber;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.NativeString;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.json.JsonParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NativeJSON
extends IdScriptableObject {
    static final long serialVersionUID = -4567599697595654984L;
    private static final Object JSON_TAG = "JSON";
    private static final int MAX_STRINGIFY_GAP_LENGTH = 10;
    private static final int Id_toSource = 1;
    private static final int Id_parse = 2;
    private static final int Id_stringify = 3;
    private static final int LAST_METHOD_ID = 3;
    private static final int MAX_ID = 3;

    static void init(Scriptable scope, boolean sealed) {
        NativeJSON obj = new NativeJSON();
        obj.activatePrototypeMap(3);
        obj.setPrototype(NativeJSON.getObjectPrototype(scope));
        obj.setParentScope(scope);
        if (sealed) {
            obj.sealObject();
        }
        ScriptableObject.defineProperty(scope, "JSON", obj, 2);
    }

    private NativeJSON() {
    }

    @Override
    public String getClassName() {
        return "JSON";
    }

    @Override
    protected void initPrototypeId(int id) {
        String name;
        int arity;
        if (id <= 3) {
            switch (id) {
                case 1: {
                    arity = 0;
                    name = "toSource";
                    break;
                }
                case 2: {
                    arity = 2;
                    name = "parse";
                    break;
                }
                case 3: {
                    arity = 3;
                    name = "stringify";
                    break;
                }
                default: {
                    throw new IllegalStateException(String.valueOf(id));
                }
            }
        } else {
            throw new IllegalStateException(String.valueOf(id));
        }
        this.initPrototypeMethod(JSON_TAG, id, name, arity);
    }

    @Override
    public Object execIdCall(IdFunctionObject f2, Context cx, Scriptable scope, Scriptable thisObj, Object[] args2) {
        if (!f2.hasTag(JSON_TAG)) {
            return super.execIdCall(f2, cx, scope, thisObj, args2);
        }
        int methodId = f2.methodId();
        switch (methodId) {
            case 1: {
                return "JSON";
            }
            case 2: {
                String jtext = ScriptRuntime.toString(args2, 0);
                Object reviver = null;
                if (args2.length > 1) {
                    reviver = args2[1];
                }
                if (reviver instanceof Callable) {
                    return NativeJSON.parse(cx, scope, jtext, (Callable)reviver);
                }
                return NativeJSON.parse(cx, scope, jtext);
            }
            case 3: {
                Object value2 = null;
                Object replacer = null;
                Object space = null;
                switch (args2.length) {
                    default: {
                        space = args2[2];
                    }
                    case 2: {
                        replacer = args2[1];
                    }
                    case 1: {
                        value2 = args2[0];
                    }
                    case 0: 
                }
                return NativeJSON.stringify(cx, scope, value2, replacer, space);
            }
        }
        throw new IllegalStateException(String.valueOf(methodId));
    }

    private static Object parse(Context cx, Scriptable scope, String jtext) {
        try {
            return new JsonParser(cx, scope).parseValue(jtext);
        }
        catch (JsonParser.ParseException ex) {
            throw ScriptRuntime.constructError("SyntaxError", ex.getMessage());
        }
    }

    public static Object parse(Context cx, Scriptable scope, String jtext, Callable reviver) {
        Object unfiltered = NativeJSON.parse(cx, scope, jtext);
        Scriptable root2 = cx.newObject(scope);
        root2.put("", root2, unfiltered);
        return NativeJSON.walk(cx, scope, reviver, root2, "");
    }

    private static Object walk(Context cx, Scriptable scope, Callable reviver, Scriptable holder, Object name) {
        Object property;
        block8: {
            property = name instanceof Number ? holder.get(((Number)name).intValue(), holder) : holder.get((String)name, holder);
            if (!(property instanceof Scriptable)) break block8;
            Scriptable val = (Scriptable)property;
            if (val instanceof NativeArray) {
                int len = (int)((NativeArray)val).getLength();
                for (int i = 0; i < len; ++i) {
                    Object newElement = NativeJSON.walk(cx, scope, reviver, val, i);
                    if (newElement == Undefined.instance) {
                        val.delete(i);
                        continue;
                    }
                    val.put(i, val, newElement);
                }
            } else {
                Object[] keys;
                for (Object p : keys = val.getIds()) {
                    Object newElement = NativeJSON.walk(cx, scope, reviver, val, p);
                    if (newElement == Undefined.instance) {
                        if (p instanceof Number) {
                            val.delete(((Number)p).intValue());
                            continue;
                        }
                        val.delete((String)p);
                        continue;
                    }
                    if (p instanceof Number) {
                        val.put(((Number)p).intValue(), val, newElement);
                        continue;
                    }
                    val.put((String)p, val, newElement);
                }
            }
        }
        return reviver.call(cx, scope, holder, new Object[]{name, property});
    }

    private static String repeat(char c, int count2) {
        char[] chars = new char[count2];
        Arrays.fill(chars, c);
        return new String(chars);
    }

    public static Object stringify(Context cx, Scriptable scope, Object value2, Object replacer, Object space) {
        String indent2 = "";
        String gap = "";
        LinkedList<Object> propertyList = null;
        Callable replacerFunction = null;
        if (replacer instanceof Callable) {
            replacerFunction = (Callable)replacer;
        } else if (replacer instanceof NativeArray) {
            propertyList = new LinkedList<Object>();
            NativeArray replacerArray = (NativeArray)replacer;
            Integer[] arr$ = replacerArray.getIndexIds();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int i = arr$[i$];
                Object v = replacerArray.get(i, (Scriptable)replacerArray);
                if (v instanceof String || v instanceof Number) {
                    propertyList.add(v);
                    continue;
                }
                if (!(v instanceof NativeString) && !(v instanceof NativeNumber)) continue;
                propertyList.add(ScriptRuntime.toString(v));
            }
        }
        if (space instanceof NativeNumber) {
            space = ScriptRuntime.toNumber(space);
        } else if (space instanceof NativeString) {
            space = ScriptRuntime.toString(space);
        }
        if (space instanceof Number) {
            int gapLength = (int)ScriptRuntime.toInteger(space);
            gap = (gapLength = Math.min(10, gapLength)) > 0 ? NativeJSON.repeat(' ', gapLength) : "";
            space = gapLength;
        } else if (space instanceof String && (gap = (String)space).length() > 10) {
            gap = gap.substring(0, 10);
        }
        StringifyState state = new StringifyState(cx, scope, indent2, gap, replacerFunction, propertyList, space);
        NativeObject wrapper = new NativeObject();
        wrapper.setParentScope(scope);
        wrapper.setPrototype(ScriptableObject.getObjectPrototype(scope));
        wrapper.defineProperty("", value2, 0);
        return NativeJSON.str("", wrapper, state);
    }

    private static Object str(Object key, Scriptable holder, StringifyState state) {
        Object toJSON;
        Object value2 = null;
        value2 = key instanceof String ? NativeJSON.getProperty(holder, (String)key) : NativeJSON.getProperty(holder, ((Number)key).intValue());
        if (value2 instanceof Scriptable && (toJSON = NativeJSON.getProperty((Scriptable)value2, "toJSON")) instanceof Callable) {
            value2 = NativeJSON.callMethod(state.cx, (Scriptable)value2, "toJSON", new Object[]{key});
        }
        if (state.replacer != null) {
            value2 = state.replacer.call(state.cx, state.scope, holder, new Object[]{key, value2});
        }
        if (value2 instanceof NativeNumber) {
            value2 = ScriptRuntime.toNumber(value2);
        } else if (value2 instanceof NativeString) {
            value2 = ScriptRuntime.toString(value2);
        } else if (value2 instanceof NativeBoolean) {
            value2 = ((NativeBoolean)value2).getDefaultValue(ScriptRuntime.BooleanClass);
        }
        if (value2 == null) {
            return "null";
        }
        if (value2.equals(Boolean.TRUE)) {
            return "true";
        }
        if (value2.equals(Boolean.FALSE)) {
            return "false";
        }
        if (value2 instanceof CharSequence) {
            return NativeJSON.quote(value2.toString());
        }
        if (value2 instanceof Number) {
            double d = ((Number)value2).doubleValue();
            if (d == d && d != Double.POSITIVE_INFINITY && d != Double.NEGATIVE_INFINITY) {
                return ScriptRuntime.toString(value2);
            }
            return "null";
        }
        if (value2 instanceof Scriptable && !(value2 instanceof Callable)) {
            if (value2 instanceof NativeArray) {
                return NativeJSON.ja((NativeArray)value2, state);
            }
            return NativeJSON.jo((Scriptable)value2, state);
        }
        return Undefined.instance;
    }

    private static String join(Collection<Object> objs, String delimiter) {
        if (objs == null || objs.isEmpty()) {
            return "";
        }
        Iterator<Object> iter2 = objs.iterator();
        if (!iter2.hasNext()) {
            return "";
        }
        StringBuilder builder = new StringBuilder(iter2.next().toString());
        while (iter2.hasNext()) {
            builder.append(delimiter).append(iter2.next().toString());
        }
        return builder.toString();
    }

    private static String jo(Scriptable value2, StringifyState state) {
        String finalValue;
        if (state.stack.search(value2) != -1) {
            throw ScriptRuntime.typeError0("msg.cyclic.value");
        }
        state.stack.push(value2);
        String stepback = state.indent;
        state.indent = state.indent + state.gap;
        Object[] k = null;
        k = state.propertyList != null ? state.propertyList.toArray() : value2.getIds();
        LinkedList<Object> partial = new LinkedList<Object>();
        for (Object p : k) {
            Object strP = NativeJSON.str(p, value2, state);
            if (strP == Undefined.instance) continue;
            String member = NativeJSON.quote(p.toString()) + ":";
            if (state.gap.length() > 0) {
                member = member + " ";
            }
            member = member + strP;
            partial.add(member);
        }
        if (partial.isEmpty()) {
            finalValue = "{}";
        } else if (state.gap.length() == 0) {
            finalValue = '{' + NativeJSON.join(partial, ",") + '}';
        } else {
            String separator = ",\n" + state.indent;
            String properties = NativeJSON.join(partial, separator);
            finalValue = "{\n" + state.indent + properties + '\n' + stepback + '}';
        }
        state.stack.pop();
        state.indent = stepback;
        return finalValue;
    }

    private static String ja(NativeArray value2, StringifyState state) {
        String finalValue;
        if (state.stack.search(value2) != -1) {
            throw ScriptRuntime.typeError0("msg.cyclic.value");
        }
        state.stack.push(value2);
        String stepback = state.indent;
        state.indent = state.indent + state.gap;
        LinkedList<Object> partial = new LinkedList<Object>();
        int len = (int)value2.getLength();
        for (int index2 = 0; index2 < len; ++index2) {
            Object strP = NativeJSON.str(index2, value2, state);
            if (strP == Undefined.instance) {
                partial.add("null");
                continue;
            }
            partial.add(strP);
        }
        if (partial.isEmpty()) {
            finalValue = "[]";
        } else if (state.gap.length() == 0) {
            finalValue = '[' + NativeJSON.join(partial, ",") + ']';
        } else {
            String separator = ",\n" + state.indent;
            String properties = NativeJSON.join(partial, separator);
            finalValue = "[\n" + state.indent + properties + '\n' + stepback + ']';
        }
        state.stack.pop();
        state.indent = stepback;
        return finalValue;
    }

    private static String quote(String string2) {
        StringBuffer product2 = new StringBuffer(string2.length() + 2);
        product2.append('\"');
        int length = string2.length();
        block9: for (int i = 0; i < length; ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case '\"': {
                    product2.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    product2.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    product2.append("\\b");
                    continue block9;
                }
                case '\f': {
                    product2.append("\\f");
                    continue block9;
                }
                case '\n': {
                    product2.append("\\n");
                    continue block9;
                }
                case '\r': {
                    product2.append("\\r");
                    continue block9;
                }
                case '\t': {
                    product2.append("\\t");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        product2.append("\\u");
                        String hex = String.format("%04x", c);
                        product2.append(hex);
                        continue block9;
                    }
                    product2.append(c);
                }
            }
        }
        product2.append('\"');
        return product2.toString();
    }

    @Override
    protected int findPrototypeId(String s2) {
        int id = 0;
        String X = null;
        switch (s2.length()) {
            case 5: {
                X = "parse";
                id = 2;
                break;
            }
            case 8: {
                X = "toSource";
                id = 1;
                break;
            }
            case 9: {
                X = "stringify";
                id = 3;
                break;
            }
        }
        if (X != null && X != s2 && !X.equals(s2)) {
            id = 0;
        }
        return id;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringifyState {
        Stack<Scriptable> stack = new Stack();
        String indent;
        String gap;
        Callable replacer;
        List<Object> propertyList;
        Object space;
        Context cx;
        Scriptable scope;

        StringifyState(Context cx, Scriptable scope, String indent2, String gap, Callable replacer, List<Object> propertyList, Object space) {
            this.cx = cx;
            this.scope = scope;
            this.indent = indent2;
            this.gap = gap;
            this.replacer = replacer;
            this.propertyList = propertyList;
            this.space = space;
        }
    }
}

